/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.UpdatesErrorIds;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.Task;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.task.TaskInstance;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RetrieveInternalTargetFilter
extends Task
implements UpdatesErrorIds {
    private static final String TRACE_MASKT = "XMCLRIFT";
    private static final String TRACE_MASKF = "XMCLRIFF";
    private static final String TRACE_MASKD = "XMCLRIFD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(2, "RetrieveInternalTargetFilter");
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObject;

    public RetrieveInternalTargetFilter(String name, UIInfo uiInfo) {
        super(name, uiInfo);
        Trace.trace(TRACE_MASKT, "<> RetrieveInternalTargetFilter constructor");
    }

    public ObjectId[] updateInitialTargets(ObjectId[] initialIds) {
        Trace.trace(TRACE_MASKT, "-> RetrieveInternalTargetFilter.updateInitialTargets()");
        Trace.trace(TRACE_MASKD, " [updateInitialTargets] Input initialIds (count is " + initialIds.length + "):");
        int count = initialIds.length;
        for (int i = 0; i < count; ++i) {
            Trace.trace(TRACE_MASKD, " [updateInitialTargets]     currentId[ " + i + " ]: " + initialIds[i]);
        }
        boolean retrieveToAllFlag = false;
        ObjectId[] newIds = null;
        PanelTasklet tasklet = (PanelTasklet)TaskInstance.getTaskInstance().get();
        LocalizableText selectedButtonText = new LocalizableText(BaseTextBundle.getBundleName(), "updates.selectedobjects.button");
        LocalizableText allButtonText = new LocalizableText(BaseTextBundle.getBundleName(), "updates.allobjects.button");
        LocalizableText[] buttons = new LocalizableText[]{selectedButtonText, allButtonText, CommonMsgInterface.HELP_BUTTON};
        try {
            LocalizableText buttonPressed = tasklet.showMessageBox(false, new BaseMessageTitle("MCL8055"), new BaseMessageText("MCL0055"), MsgType.QUESTION_MESSAGE, buttons);
            if (null != buttonPressed && buttonPressed.toString().equals(allButtonText.toString())) {
                retrieveToAllFlag = true;
                ArrayList<ObjectId> badTargetIds = new ArrayList<ObjectId>();
                ArrayList<ObjectId> managedObjectIds = new ArrayList<ObjectId>();
                int count2 = initialIds.length;
                for (int i = 0; i < count2; ++i) {
                    if (initialIds[i].isInstanceOf(class$com$ibm$hwmca$fw$managed$ManagedObject == null ? RetrieveInternalTargetFilter.class$("com.ibm.hwmca.fw.managed.ManagedObject") : class$com$ibm$hwmca$fw$managed$ManagedObject)) {
                        managedObjectIds.add(initialIds[i]);
                        continue;
                    }
                    badTargetIds.add(initialIds[i]);
                }
                Set targets = this.getIdsForSameClassManagedObjects(managedObjectIds);
                targets.addAll(badTargetIds);
                newIds = targets.toArray(new ObjectId[0]);
            }
        }
        catch (TaskletException e) {
            Trace.trace(TRACE_MASKF, " [updateInitialTargets()] Exception working with message box!");
            new FrameworkLog(classLogInfo, -3836, e).log();
            retrieveToAllFlag = false;
        }
        Trace.trace(TRACE_MASKT, "<- RetrieveInternalTargetFilter.updateInitialTargets() returning " + (retrieveToAllFlag ? newIds.length : initialIds.length) + " object IDs");
        return retrieveToAllFlag ? newIds : initialIds;
    }

    private Set getIdsForSameClassManagedObjects(List targetIds) {
        Trace.trace(TRACE_MASKT, "-> RetrieveInternalCodeTasklet.getIdsForSameClassManagedObjects()");
        ManagedObject[] targets = (ManagedObject[])HwmcaObject.getObjectsFromIds(targetIds.toArray(new ObjectId[0]), class$com$ibm$hwmca$fw$managed$ManagedObject == null ? (class$com$ibm$hwmca$fw$managed$ManagedObject = RetrieveInternalTargetFilter.class$("com.ibm.hwmca.fw.managed.ManagedObject")) : class$com$ibm$hwmca$fw$managed$ManagedObject);
        HashSet targetClasses = new HashSet();
        int count = targets.length;
        for (int i = 0; i < count; ++i) {
            targetClasses.add(targets[i].getClass());
        }
        ClassId[] classIdsArray = new ClassId[targetClasses.size()];
        int j = 0;
        Iterator iterator = targetClasses.iterator();
        while (iterator.hasNext()) {
            classIdsArray[j] = new ClassId((Class)iterator.next());
            ++j;
        }
        Trace.trace(TRACE_MASKD, " [getIdsForSameClassManagedObjects] Number of unique target object class IDs: " + classIdsArray.length);
        ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
        Set newIds = mom.getInventoryObjectIds(classIdsArray);
        Trace.trace(TRACE_MASKT, "<- RetrieveInternalCodeTasklet.getIdsForSameClassManagedObjects() returning " + newIds.size() + " object IDs");
        return newIds;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

